<?php

namespace App\Trait;

trait Imageable
{
    public function images()
    {
        return $this->morphMany(\App\Models\Image::class, 'imageable');
    }

    public function image()
    {
        return $this->morphOne(\App\Models\Image::class, 'imageable');
    }

    public function getImageAttribute()
    {
        return $this->images->first();
    }

    public function getImageUrlAttribute()
    {
        return $this->image ? $this->image->url : asset('default.png');
    }

    public function getThumbnailAttribute()
    {
        return $this->images()->where('type', 'thumbnail')->first()->url ?? asset('default.png');
    }
}
